#Cuadro IX.6
#Anlisis de varianza anidado.

##############################################
#Seccin modificable por el usuario
##############################################

#Lectura de datos.
datos<-read.csv2("Cuadro IX.6.V.csv",header=TRUE,encoding="latin1")

#Seleccin variable dependiente. En caso de que se deseen utilizar valores transformados, desmarcamos la transformacin que nos interese como "NULL".
varInteres<-c("Nmero.de.especies.de.lquenes")

#Seleccin de un tipo de transformacin para las variables de inters. Si no se transforma la variable debe mantenerse la opcin "NULL".
varInteres1X2<-NULL
varInteres1X<-NULL
varInteresLN<-NULL
varInteresLOG10<-NULL
varInteresSQR<-NULL
varInteresX2<-NULL
varInteresX3<-NULL
varInteresEX<-NULL
varInteresASN<-NULL

#varInteres1X2<-c(1,1)
#varInteres1X<-c(1,1)
#varInteresLN<-c(1,1)
#varInteresLOG10<-c(1,1)
#varInteresSQR<-c(1,1)
#varInteresX2<-c(1,1)
#varInteresX3<-c(1,1)
#varInteresEX<-c(1,1)
#varInteresASN<-c(1,1)

#Variables que corresponden a los factores.
Factor1<-c("Ciudad")
Factor2<-c("Especie.Arbol")
Factor3<-c("Grado.Contaminacin")
#Factor3<-NULL
#Factor4<-c("")
Factor4<-NULL

##Posibilidades de anidamiento de los factores
#Para 2 factores
	#1.Factor2 en Factor1
#Para 3 factores
	#2.Factor3 en Factor2
	#3.Factor3 en Factor2.Factor2 en Factor1
#Para 4 factores
	#4.Factor4 en Factor3
	#5.Factor4 en Factor3. Factor2 en Factor1
	#6.Factor4 en Factor3. Factor3 en Factor2
	#7.Factor4 en Factor3. Factor3 en Factor2. Factor2 en Factor1.

anidamiento<-3

#Tipo de suma de cuadrados
#SS<-c(2)
SS<-c(3)

#Variables de seleccin.
#varSeleccion1<-list(c("","",""))
varSeleccion1<-NULL
#varSeleccion2<-list(c("","",""))
varSeleccion2<-NULL

#Archivo de salida.
ArchivodeSalida<-"Salida Cuadro IX.6.txt"

###############################################
#Seccin que realiza el procedimiento
###############################################

#paquetes
require(e1071)
require(car)
require(lawstat)
require(nortest)
require(multcomp)

##Organizacin de los datos.
valores<-(datos[,varInteres])
if (length(varInteres1X2)==2) valores<-1/((datos[,varInteres])^2)
if (length(varInteres1X)==2) valores<-1/(datos[,varInteres])
if (length(varInteresLN)==2) valores<-log(datos[,varInteres])
if (length(varInteresLOG10)==2) valores<-log10(datos[,varInteres])
if (length(varInteresSQR)==2) valores<-sqrt((datos[,varInteres]))
if (length(varInteresX2)==2) valores<-(datos[,varInteres])^2
if (length(varInteresX3)==2) valores<-(datos[,varInteres])^3
if (length(varInteresEX)==2) valores<-exp(datos[,varInteres])
if (length(varInteresASN)==2) valores<-asin((datos[,varInteres]))

#Factores
factores<-data.frame(datos[,c(Factor1,Factor2,Factor3,Factor4)])
if (ncol(factores)==1) names(factores)<-c("Factor1")
if (ncol(factores)==2) names(factores)<-c("Factor1","Factor2")
if (ncol(factores)==3) names(factores)<-c("Factor1","Factor2","Factor3")
if (ncol(factores)==4) names(factores)<-c("Factor1","Factor2","Factor3","Factor4")
if (ncol(factores)==1) F1<-as.factor(factores[,"Factor1"])
if (ncol(factores)==2) {F1<-as.factor(factores[,"Factor1"])
                        F2<-as.factor(factores[,"Factor2"])
}
if (ncol(factores)==3) {F1<-as.factor(factores[,"Factor1"])
                        F2<-as.factor(factores[,"Factor2"])
                        F3<-as.factor(factores[,"Factor3"])
}
if (ncol(factores)==4) {F1<-as.factor(factores[,"Factor1"])
                        F2<-as.factor(factores[,"Factor2"])
                        F3<-as.factor(factores[,"Factor3"])
                        F4<-as.factor(factores[,"Factor4"])
}

if (ncol(factores)==1) factores2<-data.frame(F1)
if (ncol(factores)==2) factores2<-data.frame(F1,F2)
if (ncol(factores)==3) factores2<-data.frame(F1,F2,F3)
if (ncol(factores)==4) factores2<-data.frame(F1,F2,F3,F4)

#Seleccion
if (length(varSeleccion1)!=0){
 w1<-data.frame(row.names=1:dim(datos)[1])
 varBin1<-as.character()
 for (i in 1:length(varSeleccion1)){
   nom1<-varSeleccion1[[i]][1]
   x1<-factor(datos[,nom1])
   if (length(varSeleccion1[[i]])>1){
      sufijo1<-paste(varSeleccion1[[i]][2:3],collapse="_")
      nom1<-paste(nom1,".",sufijo1,sep="")
      x11<-factor(ifelse(x1 %in% varSeleccion1[[i]][2:3],as.character(x1),NA))
      x11<-data.frame(factor(x11))
   }else{
      x11<-x1
      x11<-data.frame(x1)
   }
   names(x11)<-nom1
   varBin1<-c(varBin1,nom1)
   w1<-data.frame(w1,x11)
 }
}

if (length(varSeleccion2)!=0){
 w2<-data.frame(row.names=1:dim(datos)[1])
 varBin2<-as.character()
 for (i in 1:length(varSeleccion2)){
   nom2<-varSeleccion2[[i]][1]
   x2<-factor(datos[,nom2])
   if (length(varSeleccion2[[i]])>1){
      sufijo2<-paste(varSeleccion2[[i]][2:3],collapse="_")
      nom2<-paste(nom2,".",sufijo2,sep="")
      x12<-factor(ifelse(x2 %in% varSeleccion2[[i]][2:3],as.character(x2),NA))
      x12<-data.frame(factor(x12))
   }else{
      x12<-x2
      x12<-data.frame(x2)
   }
   names(x12)<-nom2
   varBin2<-c(varBin2,nom2)
   w2<-data.frame(w2,x12)
 }
}

if ((length(varSeleccion1)!=0)&(length(varSeleccion2)!=0)) seleccion<-data.frame(w1,w2)
if ((length(varSeleccion1)!=0)&(length(varSeleccion2)==0)) seleccion<-data.frame(w1)
if ((length(varSeleccion1)==0)&(length(varSeleccion2)!=0)) seleccion<-data.frame(w2)
if ((length(varSeleccion1)==0)&(length(varSeleccion2)==0)) seleccion<-NULL

#Conjunto de datos
if (length(seleccion)==0) datos2<-data.frame(valores,factores2)
if (length(seleccion)!=0) datos2<-data.frame(seleccion,valores,factores2)
datos2<-na.omit(datos2)

#Modelo lineal univariante y extraccin de resduos.
options(contrasts=c("contr.sum", "contr.poly"))

for (i in anidamiento){
  if (i==1){modelo<-lm(valores~F1+F2%in%F1,data=datos2)
           Resumenmodelo<-Anova(modelo,idata=factores2,idesign=~F1+F2%in%F1,type=SS)}
  if (i==2){modelo<-lm(valores~F1+F2+F3%in%F2,data=datos2)
           Resumenmodelo<-Anova(modelo,idata=factores2,idesign=~F1+F2+F3%in%F2,type=SS)}
  if (i==3){modelo<-lm(valores~F1+F2%in%F1+F3%in%F2,data=datos2)
           Resumenmodelo<-Anova(modelo,idata=factores2,idesign=~F1+F2%in%F1*F3%in%F2,type=SS)}
  if (i==4){modelo<-lm(valores~F1+F2+F3+F4%in%F3,data=datos2)
           Resumenmodelo<-Anova(modelo,idata=factores2,idesign=~F1+F2+F3+F4%in%F3,type=SS)}
  if (i==5){modelo<-lm(valores~F1+F2%in%F1+F3+F4%in%F3,data=datos2)
           Resumenmodelo<-Anova(modelo,idata=factores2,idesign=~F1+F2%in%F1+F3+F4%in%F3,type=SS)}
  if (i==6){modelo<-lm(valores~F1+F2+F3%in%F2+F4%in%F3,data=datos2)
           Resumenmodelo<-Anova(modelo,idata=factores2,idesign=~F1+F2+F3%in%F2+F4%in%F3,type=SS)}
  if (i==7){modelo<-lm(valores~F1+F2%in%F1+F3%in%F2+F4%in%F3,data=datos2)
           Resumenmodelo<-Anova(modelo,idata=factores2,idesign=~F1+F2%in%F1+F3%in%F2+F4%in%F3,type=SS)}
}

#Extraccin de resduos
residuos<-residuals(modelo)
datos3<-data.frame(residuos,datos2)

Factores<-c("Factores empleados en el anlisis:",list(Factor1,Factor2,Factor3,Factor4))

#Tamao de efecto.
Efectos<-summary.lm(modelo)

#prueba de normalidad en los resduos.
PruebaNormLillie<-lillie.test(residuos)
PruebaNormShapiro<-shapiro.test(residuos)

##Prueba de heterocedasticidad en los resduos.
if (ncol(factores)==1) {PruebaHetF1M<-levene.test(datos3$residuos,datos3$F1)
                        PruebaHetF2M<-NULL
                        PruebaHetF3M<-NULL
                        PruebaHetF4M<-NULL
}
if (ncol(factores)==2) {PruebaHetF1M<-levene.test(datos3$residuos,datos3$F1)
                        PruebaHetF2M<-levene.test(datos3$residuos,datos3$F2)
                        PruebaHetF3M<-NULL
                        PruebaHetF4M<-NULL
}
if (ncol(factores)==3) {PruebaHetF1M<-levene.test(datos3$residuos,datos3$F1)
                        PruebaHetF2M<-levene.test(datos3$residuos,datos3$F2)
                        PruebaHetF3M<-levene.test(datos3$residuos,datos3$F3)
                        PruebaHetF4M<-NULL
}
if (ncol(factores)==4) {PruebaHetF1M<-levene.test(datos3$residuos,datos3$F1)
                        PruebaHetF2M<-levene.test(datos3$residuos,datos3$F2)
                        PruebaHetF3M<-levene.test(datos3$residuos,datos3$F3)
                        PruebaHetF4M<-levene.test(datos3$residuos,datos3$F4)
}

PruebaHet<-list("Factor1",PruebaHetF1M,"Factor2",PruebaHetF2M,"Factor3",PruebaHetF3M,"Factor4",PruebaHetF4M)

#Sesgo.
Sesgodatos<-c("Sesgo",skewness(datos3$residuos,type=2))
Curtosisdatos<-c("Curtosis",kurtosis(datos3$residuos,type=2))

#Pruebas post-hoc
if (ncol(factores)==1){dv<-c(datos2[,"valores"])
                       Factor1<-factor(c(datos2[,"F1"]))
                       modelo2<-lm(dv~Factor1)
                       Anova(modelo2,type=SS)
                       PostHoc<-summary(glht(modelo2,linfct=mcp(Factor1="Tukey")))
}
if (ncol(factores)==2){dv<-c(datos2[,"valores"])
                       Factor1<-factor(c(datos2[,"F1"]))
                       Factor2<-factor(c(datos2[,"F2"]))
                       modelo2<-lm(dv~Factor1*Factor2)
                       Anova(modelo2,type=SS)
                       PostHoc<-summary(glht(modelo2,linfct=mcp(Factor1="Tukey",Factor2="Tukey")))
}
if (ncol(factores)==3){dv<-c(datos2[,"valores"])
                       Factor1<-factor(c(datos2[,"F1"]))
                       Factor2<-factor(c(datos2[,"F2"]))
                       Factor3<-factor(c(datos2[,"F3"]))
                       modelo2<-lm(dv~Factor1*Factor2*Factor3)
                       Anova(modelo2,type=SS)
                       PostHoc<-summary(glht(modelo2,linfct=mcp(Factor1="Tukey",Factor2="Tukey",Factor3="Tukey")))
}
if (ncol(factores)==4){dv<-c(datos2[,"valores"])
                       Factor1<-factor(c(datos2[,"F1"]))
                       Factor2<-factor(c(datos2[,"F2"]))
                       Factor3<-factor(c(datos2[,"F3"]))
                       Factor4<-factor(c(datos2[,"F4"]))
                       modelo2<-lm(dv~Factor1*Factor2*Factor3*Factor4)
                       Anova(modelo2,type=SS)
                       PostHoc<-summary(glht(modelo2,linfct=mcp(Factor1="Tukey",Factor2="Tukey",Factor3="Tukey",Factor4="Tukey")))
}

###############################################
#Seccin que muestra los resultados
###############################################

Resultados<-list(Factores,Resumenmodelo,Efectos,PruebaNormLillie,PruebaNormShapiro,PruebaHet,Sesgodatos,Curtosisdatos,PostHoc)

if(!is.null(ArchivodeSalida)){
 sink(ArchivodeSalida)
 print(Resultados)
 sink()
}

